/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.python.google.common.base.Platform;
import org.python.google.common.base.Preconditions;
import org.python.google.common.base.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public abstract class CharMatcher
implements Predicate<Character> {
    private static final String BREAKING_WHITESPACE_CHARS = "\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000";
    private static final String NON_BREAKING_WHITESPACE_CHARS = "\u00a0\u180e\u202f";
    public static final CharMatcher WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000\u00a0\u180e\u202f").or(CharMatcher.inRange('\u2000', '\u200a')).precomputed();
    public static final CharMatcher BREAKING_WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000").or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200a')).precomputed();
    public static final CharMatcher ASCII = CharMatcher.inRange('\u0000', '\u007f');
    public static final CharMatcher DIGIT;
    public static final CharMatcher JAVA_WHITESPACE;
    public static final CharMatcher JAVA_DIGIT;
    public static final CharMatcher JAVA_LETTER;
    public static final CharMatcher JAVA_LETTER_OR_DIGIT;
    public static final CharMatcher JAVA_UPPER_CASE;
    public static final CharMatcher JAVA_LOWER_CASE;
    public static final CharMatcher JAVA_ISO_CONTROL;
    public static final CharMatcher INVISIBLE;
    public static final CharMatcher SINGLE_WIDTH;
    public static final CharMatcher ANY;
    public static final CharMatcher NONE;

    public static CharMatcher is(final char c) {
        return new CharMatcher(){

            public boolean matches(char c2) {
                return c2 == c;
            }

            public String replaceFrom(CharSequence charSequence, char c2) {
                return ((Object)charSequence).toString().replace(c, c2);
            }

            public CharMatcher and(CharMatcher charMatcher) {
                return charMatcher.matches(c) ? this : NONE;
            }

            public CharMatcher or(CharMatcher charMatcher) {
                return charMatcher.matches(c) ? charMatcher : super.or(charMatcher);
            }

            public CharMatcher negate() {
                return 8.isNot(c);
            }

            void setBits(LookupTable lookupTable) {
                lookupTable.set(c);
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher isNot(final char c) {
        return new CharMatcher(){

            public boolean matches(char c2) {
                return c2 != c;
            }

            public CharMatcher and(CharMatcher charMatcher) {
                return charMatcher.matches(c) ? super.and(charMatcher) : charMatcher;
            }

            public CharMatcher or(CharMatcher charMatcher) {
                return charMatcher.matches(c) ? ANY : this;
            }

            public CharMatcher negate() {
                return 9.is(c);
            }
        };
    }

    public static CharMatcher anyOf(CharSequence charSequence) {
        switch (charSequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is(charSequence.charAt(0));
            }
            case 2: {
                final char c = charSequence.charAt(0);
                final char c2 = charSequence.charAt(1);
                return new CharMatcher(){

                    public boolean matches(char c3) {
                        return c3 == c || c3 == c2;
                    }

                    void setBits(LookupTable lookupTable) {
                        lookupTable.set(c);
                        lookupTable.set(c2);
                    }

                    public CharMatcher precomputed() {
                        return this;
                    }
                };
            }
        }
        final char[] cArray = ((Object)charSequence).toString().toCharArray();
        Arrays.sort(cArray);
        return new CharMatcher(){

            public boolean matches(char c) {
                return Arrays.binarySearch(cArray, c) >= 0;
            }

            void setBits(LookupTable lookupTable) {
                for (char c : cArray) {
                    lookupTable.set(c);
                }
            }
        };
    }

    public static CharMatcher noneOf(CharSequence charSequence) {
        return CharMatcher.anyOf(charSequence).negate();
    }

    public static CharMatcher inRange(final char c, final char c2) {
        Preconditions.checkArgument(c2 >= c);
        return new CharMatcher(){

            public boolean matches(char c3) {
                return c <= c3 && c3 <= c2;
            }

            void setBits(LookupTable lookupTable) {
                char c3;
                char c22 = c;
                do {
                    lookupTable.set(c22);
                    c3 = c22;
                    c22 = (char)(c22 + '\u0001');
                } while (c3 != c2);
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher forPredicate(final Predicate<? super Character> predicate) {
        Preconditions.checkNotNull(predicate);
        if (predicate instanceof CharMatcher) {
            return (CharMatcher)predicate;
        }
        return new CharMatcher(){

            public boolean matches(char c) {
                return predicate.apply(Character.valueOf(c));
            }

            public boolean apply(Character c) {
                return predicate.apply(Preconditions.checkNotNull(c));
            }
        };
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        final CharMatcher charMatcher = this;
        return new CharMatcher(){

            public boolean matches(char c) {
                return !charMatcher.matches(c);
            }

            public boolean matchesAllOf(CharSequence charSequence) {
                return charMatcher.matchesNoneOf(charSequence);
            }

            public boolean matchesNoneOf(CharSequence charSequence) {
                return charMatcher.matchesAllOf(charSequence);
            }

            public int countIn(CharSequence charSequence) {
                return charSequence.length() - charMatcher.countIn(charSequence);
            }

            public CharMatcher negate() {
                return charMatcher;
            }
        };
    }

    public CharMatcher and(CharMatcher charMatcher) {
        return new And(Arrays.asList(this, Preconditions.checkNotNull(charMatcher)));
    }

    public CharMatcher or(CharMatcher charMatcher) {
        return new Or(Arrays.asList(this, Preconditions.checkNotNull(charMatcher)));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    CharMatcher precomputedInternal() {
        final LookupTable lookupTable = new LookupTable();
        this.setBits(lookupTable);
        return new CharMatcher(){

            public boolean matches(char c) {
                return lookupTable.get(c);
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    void setBits(LookupTable lookupTable) {
        char c;
        char c2 = '\u0000';
        do {
            if (this.matches(c2)) {
                lookupTable.set(c2);
            }
            c = c2;
            c2 = (char)(c2 + '\u0001');
        } while (c != 65535);
    }

    public boolean matchesAllOf(CharSequence charSequence) {
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            if (this.matches(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence charSequence) {
        return this.indexIn(charSequence) == -1;
    }

    public int indexIn(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (!this.matches(charSequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int indexIn(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        Preconditions.checkPositionIndex(n, n2);
        for (int i = n; i < n2; ++i) {
            if (!this.matches(charSequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence charSequence) {
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            if (!this.matches(charSequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int countIn(CharSequence charSequence) {
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (!this.matches(charSequence.charAt(i))) continue;
            ++n;
        }
        return n;
    }

    public String removeFrom(CharSequence charSequence) {
        String string = ((Object)charSequence).toString();
        int n = this.indexIn(string);
        if (n == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = 1;
        block0: while (true) {
            ++n;
            while (n != cArray.length) {
                if (!this.matches(cArray[n])) {
                    cArray[n - n2] = cArray[n];
                    ++n;
                    continue;
                }
                ++n2;
                continue block0;
            }
            break;
        }
        return new String(cArray, 0, n - n2);
    }

    public String retainFrom(CharSequence charSequence) {
        return this.negate().removeFrom(charSequence);
    }

    public String replaceFrom(CharSequence charSequence, char c) {
        String string = ((Object)charSequence).toString();
        int n = this.indexIn(string);
        if (n == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[n] = c;
        for (int i = n + 1; i < cArray.length; ++i) {
            if (!this.matches(cArray[i])) continue;
            cArray[i] = c;
        }
        return new String(cArray);
    }

    public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence2.length();
        if (n == 0) {
            return this.removeFrom(charSequence);
        }
        if (n == 1) {
            return this.replaceFrom(charSequence, charSequence2.charAt(0));
        }
        String string = ((Object)charSequence).toString();
        int n2 = this.indexIn(string);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n3 * 3 / 2 + 16);
        int n4 = 0;
        do {
            stringBuilder.append(string, n4, n2);
            stringBuilder.append(charSequence2);
        } while ((n2 = this.indexIn(string, n4 = n2 + 1)) != -1);
        stringBuilder.append(string, n4, n3);
        return stringBuilder.toString();
    }

    public String trimFrom(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && this.matches(charSequence.charAt(n2)); ++n2) {
        }
        for (n = n3 - 1; n > n2 && this.matches(charSequence.charAt(n)); --n) {
        }
        return ((Object)charSequence.subSequence(n2, n + 1)).toString();
    }

    public String trimLeadingFrom(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        for (n = 0; n < n2 && this.matches(charSequence.charAt(n)); ++n) {
        }
        return ((Object)charSequence.subSequence(n, n2)).toString();
    }

    public String trimTrailingFrom(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        for (n = n2 - 1; n >= 0 && this.matches(charSequence.charAt(n)); --n) {
        }
        return ((Object)charSequence.subSequence(0, n + 1)).toString();
    }

    public String collapseFrom(CharSequence charSequence, char c) {
        int n = this.indexIn(charSequence);
        if (n == -1) {
            return ((Object)charSequence).toString();
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length()).append(charSequence.subSequence(0, n)).append(c);
        boolean bl = true;
        for (int i = n + 1; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            if (this.apply(Character.valueOf(c2))) {
                if (bl) continue;
                stringBuilder.append(c);
                bl = true;
                continue;
            }
            stringBuilder.append(c2);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public String trimAndCollapseFrom(CharSequence charSequence, char c) {
        int n = this.negate().indexIn(charSequence);
        if (n == -1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        boolean bl = false;
        for (int i = n; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            if (this.apply(Character.valueOf(c2))) {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
                bl = false;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean apply(Character c) {
        return this.matches(c.charValue());
    }

    static {
        CharMatcher charMatcher = CharMatcher.inRange('0', '9');
        String string = "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
        for (char c : string.toCharArray()) {
            charMatcher = charMatcher.or(CharMatcher.inRange(c, (char)(c + 9)));
        }
        DIGIT = charMatcher.precomputed();
        JAVA_WHITESPACE = CharMatcher.inRange('\t', '\r').or(CharMatcher.inRange('\u001c', ' ')).or(CharMatcher.is('\u1680')).or(CharMatcher.is('\u180e')).or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200b')).or(CharMatcher.inRange('\u2028', '\u2029')).or(CharMatcher.is('\u205f')).or(CharMatcher.is('\u3000')).precomputed();
        JAVA_DIGIT = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isDigit(c);
            }
        };
        JAVA_LETTER = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isLetter(c);
            }
        };
        JAVA_LETTER_OR_DIGIT = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isLetterOrDigit(c);
            }
        };
        JAVA_UPPER_CASE = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isUpperCase(c);
            }
        };
        JAVA_LOWER_CASE = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isLowerCase(c);
            }
        };
        JAVA_ISO_CONTROL = CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f'));
        INVISIBLE = CharMatcher.inRange('\u0000', ' ').or(CharMatcher.inRange('\u007f', '\u00a0')).or(CharMatcher.is('\u00ad')).or(CharMatcher.inRange('\u0600', '\u0603')).or(CharMatcher.anyOf("\u06dd\u070f\u1680\u17b4\u17b5\u180e")).or(CharMatcher.inRange('\u2000', '\u200f')).or(CharMatcher.inRange('\u2028', '\u202f')).or(CharMatcher.inRange('\u205f', '\u2064')).or(CharMatcher.inRange('\u206a', '\u206f')).or(CharMatcher.is('\u3000')).or(CharMatcher.inRange('\ud800', '\uf8ff')).or(CharMatcher.anyOf("\ufeff\ufff9\ufffa\ufffb")).precomputed();
        SINGLE_WIDTH = CharMatcher.inRange('\u0000', '\u04f9').or(CharMatcher.is('\u05be')).or(CharMatcher.inRange('\u05d0', '\u05ea')).or(CharMatcher.is('\u05f3')).or(CharMatcher.is('\u05f4')).or(CharMatcher.inRange('\u0600', '\u06ff')).or(CharMatcher.inRange('\u0750', '\u077f')).or(CharMatcher.inRange('\u0e00', '\u0e7f')).or(CharMatcher.inRange('\u1e00', '\u20af')).or(CharMatcher.inRange('\u2100', '\u213a')).or(CharMatcher.inRange('\ufb50', '\ufdff')).or(CharMatcher.inRange('\ufe70', '\ufeff')).or(CharMatcher.inRange('\uff61', '\uffdc')).precomputed();
        ANY = new CharMatcher(){

            public boolean matches(char c) {
                return true;
            }

            public int indexIn(CharSequence charSequence) {
                return charSequence.length() == 0 ? -1 : 0;
            }

            public int indexIn(CharSequence charSequence, int n) {
                int n2 = charSequence.length();
                Preconditions.checkPositionIndex(n, n2);
                return n == n2 ? -1 : n;
            }

            public int lastIndexIn(CharSequence charSequence) {
                return charSequence.length() - 1;
            }

            public boolean matchesAllOf(CharSequence charSequence) {
                Preconditions.checkNotNull(charSequence);
                return true;
            }

            public boolean matchesNoneOf(CharSequence charSequence) {
                return charSequence.length() == 0;
            }

            public String removeFrom(CharSequence charSequence) {
                Preconditions.checkNotNull(charSequence);
                return "";
            }

            public String replaceFrom(CharSequence charSequence, char c) {
                char[] cArray = new char[charSequence.length()];
                Arrays.fill(cArray, c);
                return new String(cArray);
            }

            public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
                StringBuilder stringBuilder = new StringBuilder(charSequence.length() * charSequence2.length());
                for (int i = 0; i < charSequence.length(); ++i) {
                    stringBuilder.append(charSequence2);
                }
                return stringBuilder.toString();
            }

            public String collapseFrom(CharSequence charSequence, char c) {
                return charSequence.length() == 0 ? "" : String.valueOf(c);
            }

            public String trimFrom(CharSequence charSequence) {
                Preconditions.checkNotNull(charSequence);
                return "";
            }

            public int countIn(CharSequence charSequence) {
                return charSequence.length();
            }

            public CharMatcher and(CharMatcher charMatcher) {
                return Preconditions.checkNotNull(charMatcher);
            }

            public CharMatcher or(CharMatcher charMatcher) {
                Preconditions.checkNotNull(charMatcher);
                return this;
            }

            public CharMatcher negate() {
                return NONE;
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
        NONE = new CharMatcher(){

            public boolean matches(char c) {
                return false;
            }

            public int indexIn(CharSequence charSequence) {
                Preconditions.checkNotNull(charSequence);
                return -1;
            }

            public int indexIn(CharSequence charSequence, int n) {
                int n2 = charSequence.length();
                Preconditions.checkPositionIndex(n, n2);
                return -1;
            }

            public int lastIndexIn(CharSequence charSequence) {
                Preconditions.checkNotNull(charSequence);
                return -1;
            }

            public boolean matchesAllOf(CharSequence charSequence) {
                return charSequence.length() == 0;
            }

            public boolean matchesNoneOf(CharSequence charSequence) {
                Preconditions.checkNotNull(charSequence);
                return true;
            }

            public String removeFrom(CharSequence charSequence) {
                return ((Object)charSequence).toString();
            }

            public String replaceFrom(CharSequence charSequence, char c) {
                return ((Object)charSequence).toString();
            }

            public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
                Preconditions.checkNotNull(charSequence2);
                return ((Object)charSequence).toString();
            }

            public String collapseFrom(CharSequence charSequence, char c) {
                return ((Object)charSequence).toString();
            }

            public String trimFrom(CharSequence charSequence) {
                return ((Object)charSequence).toString();
            }

            public int countIn(CharSequence charSequence) {
                Preconditions.checkNotNull(charSequence);
                return 0;
            }

            public CharMatcher and(CharMatcher charMatcher) {
                Preconditions.checkNotNull(charMatcher);
                return this;
            }

            public CharMatcher or(CharMatcher charMatcher) {
                return Preconditions.checkNotNull(charMatcher);
            }

            public CharMatcher negate() {
                return ANY;
            }

            void setBits(LookupTable lookupTable) {
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class And
    extends CharMatcher {
        List<CharMatcher> components;

        And(List<CharMatcher> list) {
            this.components = list;
        }

        @Override
        public boolean matches(char c) {
            for (CharMatcher charMatcher : this.components) {
                if (charMatcher.matches(c)) continue;
                return false;
            }
            return true;
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            ArrayList<CharMatcher> arrayList = new ArrayList<CharMatcher>(this.components);
            arrayList.add(Preconditions.checkNotNull(charMatcher));
            return new And(arrayList);
        }
    }

    private static final class LookupTable {
        int[] data = new int[2048];

        private LookupTable() {
        }

        void set(char c) {
            int n = c >> 5;
            this.data[n] = this.data[n] | '\u0001' << c;
        }

        boolean get(char c) {
            return (this.data[c >> 5] & '\u0001' << c) != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Or
    extends CharMatcher {
        List<CharMatcher> components;

        Or(List<CharMatcher> list) {
            this.components = list;
        }

        @Override
        public boolean matches(char c) {
            for (CharMatcher charMatcher : this.components) {
                if (!charMatcher.matches(c)) continue;
                return true;
            }
            return false;
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            ArrayList<CharMatcher> arrayList = new ArrayList<CharMatcher>(this.components);
            arrayList.add(Preconditions.checkNotNull(charMatcher));
            return new Or(arrayList);
        }

        @Override
        void setBits(LookupTable lookupTable) {
            for (CharMatcher charMatcher : this.components) {
                charMatcher.setBits(lookupTable);
            }
        }
    }
}

